--
-- PostgreSQL database dump
--

-- Dumped from database version 16.1
-- Dumped by pg_dump version 16.1

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: agamas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.agamas (
    id uuid NOT NULL,
    kode character varying(255) NOT NULL,
    nama character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.agamas OWNER TO postgres;

--
-- Name: banksoal_adaptif; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.banksoal_adaptif (
    id uuid NOT NULL,
    matpel_id uuid NOT NULL,
    code character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    max_pg integer NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.banksoal_adaptif OWNER TO postgres;

--
-- Name: banksoals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.banksoals (
    id uuid NOT NULL,
    kode_banksoal character varying(100) NOT NULL,
    jumlah_soal integer NOT NULL,
    jumlah_pilihan integer DEFAULT 4 NOT NULL,
    jumlah_soal_listening integer DEFAULT 0 NOT NULL,
    jumlah_pilihan_listening integer DEFAULT 4 NOT NULL,
    jumlah_soal_esay integer DEFAULT 0,
    jumlah_soal_ganda_kompleks integer DEFAULT 0 NOT NULL,
    jumlah_isian_singkat integer DEFAULT 0 NOT NULL,
    jumlah_menjodohkan integer DEFAULT 0 NOT NULL,
    jumlah_mengurutkan integer DEFAULT 0 NOT NULL,
    jumlah_benar_salah integer DEFAULT 0 NOT NULL,
    jumlah_setuju_tidak integer DEFAULT 0 NOT NULL,
    is_locked integer DEFAULT 0 NOT NULL,
    key_lock character varying(255),
    lock_by uuid,
    persen character varying(255) NOT NULL,
    matpel_id uuid NOT NULL,
    author uuid NOT NULL,
    directory_id uuid NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.banksoals OWNER TO postgres;

--
-- Name: COLUMN banksoals.jumlah_soal; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_soal IS 'jumlah soal pilihan ganda';


--
-- Name: COLUMN banksoals.jumlah_pilihan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_pilihan IS 'jumlah pilihan / opsi pada pilihan ganda';


--
-- Name: COLUMN banksoals.jumlah_soal_listening; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_soal_listening IS 'jumlah soal listening';


--
-- Name: COLUMN banksoals.jumlah_pilihan_listening; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_pilihan_listening IS 'jumlah opsi listening';


--
-- Name: COLUMN banksoals.jumlah_soal_ganda_kompleks; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_soal_ganda_kompleks IS 'jumlah soal pilihan ganda kompleks';


--
-- Name: COLUMN banksoals.jumlah_isian_singkat; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_isian_singkat IS 'jumlah isian singkat';


--
-- Name: COLUMN banksoals.jumlah_menjodohkan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_menjodohkan IS 'jumlah menjodohkan';


--
-- Name: COLUMN banksoals.jumlah_mengurutkan; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_mengurutkan IS 'jumlah mengurutkan';


--
-- Name: COLUMN banksoals.jumlah_benar_salah; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_benar_salah IS 'jumlah benar-salah';


--
-- Name: COLUMN banksoals.jumlah_setuju_tidak; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.banksoals.jumlah_setuju_tidak IS 'jumlah setuju-tidak';


--
-- Name: directories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.directories (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    slug character varying(255) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.directories OWNER TO postgres;

--
-- Name: event_ujians; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_ujians (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.event_ujians OWNER TO postgres;

--
-- Name: exo_backups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.exo_backups (
    id bigint NOT NULL,
    filename character varying(255) NOT NULL,
    version character varying(255) NOT NULL,
    detail text NOT NULL,
    generated_date character varying(255) NOT NULL,
    bak_type character varying(255) DEFAULT 'BACKUP'::character varying NOT NULL,
    status character varying(255) DEFAULT 'SUCCESS'::character varying NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.exo_backups OWNER TO postgres;

--
-- Name: exo_backups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.exo_backups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.exo_backups_id_seq OWNER TO postgres;

--
-- Name: exo_backups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.exo_backups_id_seq OWNED BY public.exo_backups.id;


--
-- Name: failed_jobs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.failed_jobs (
    id uuid NOT NULL,
    connection text NOT NULL,
    queue text NOT NULL,
    payload text NOT NULL,
    exception text NOT NULL,
    failed_at timestamp(0) without time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);


ALTER TABLE public.failed_jobs OWNER TO postgres;

--
-- Name: feature_infos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.feature_infos (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    code character varying(255) NOT NULL,
    content text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.feature_infos OWNER TO postgres;

--
-- Name: feature_infos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.feature_infos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.feature_infos_id_seq OWNER TO postgres;

--
-- Name: feature_infos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.feature_infos_id_seq OWNED BY public.feature_infos.id;


--
-- Name: files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.files (
    id uuid NOT NULL,
    directory_id uuid NOT NULL,
    dirname character varying(255) NOT NULL,
    filename character varying(255) NOT NULL,
    path character varying(255) NOT NULL,
    exstension character varying(255) NOT NULL,
    size character varying(255) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.files OWNER TO postgres;

--
-- Name: group_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.group_members (
    id uuid NOT NULL,
    group_id uuid NOT NULL,
    student_id uuid NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.group_members OWNER TO postgres;

--
-- Name: groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.groups (
    id uuid NOT NULL,
    parent_id uuid,
    name character varying(255) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.groups OWNER TO postgres;

--
-- Name: hasil_ujians; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.hasil_ujians (
    id uuid NOT NULL,
    ujian_id uuid,
    banksoal_id uuid NOT NULL,
    peserta_id uuid NOT NULL,
    jadwal_id uuid NOT NULL,
    jumlah_salah integer DEFAULT 0 NOT NULL,
    jumlah_benar integer DEFAULT 0 NOT NULL,
    jumlah_benar_complek integer DEFAULT 0 NOT NULL,
    jumlah_salah_complek integer DEFAULT 0 NOT NULL,
    jumlah_benar_listening integer DEFAULT 0 NOT NULL,
    jumlah_salah_listening integer DEFAULT 0 NOT NULL,
    jumlah_benar_isian_singkat integer DEFAULT 0 NOT NULL,
    jumlah_salah_isian_singkat integer DEFAULT 0 NOT NULL,
    jumlah_benar_menjodohkan integer DEFAULT 0 NOT NULL,
    jumlah_salah_menjodohkan integer DEFAULT 0 NOT NULL,
    jumlah_benar_mengurutkan integer DEFAULT 0 NOT NULL,
    jumlah_salah_mengurutkan integer DEFAULT 0 NOT NULL,
    jumlah_benar_benar_salah integer DEFAULT 0 NOT NULL,
    jumlah_salah_benar_salah integer DEFAULT 0 NOT NULL,
    point_esay double precision NOT NULL,
    point_setuju_tidak double precision NOT NULL,
    tidak_diisi integer NOT NULL,
    hasil double precision NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.hasil_ujians OWNER TO postgres;

--
-- Name: jadwals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.jadwals (
    id uuid NOT NULL,
    banksoal_id text NOT NULL,
    group_ids text,
    alias character varying(50) NOT NULL,
    tanggal date NOT NULL,
    mulai time(0) without time zone NOT NULL,
    lama integer NOT NULL,
    min_test integer DEFAULT 0 NOT NULL,
    status_ujian character(1) NOT NULL,
    event_id uuid,
    sesi integer DEFAULT 1 NOT NULL,
    setting text NOT NULL,
    mulai_sesi text,
    view_result integer DEFAULT 0 NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_by uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.jadwals OWNER TO postgres;

--
-- Name: jawaban_pesertas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.jawaban_pesertas (
    id uuid NOT NULL,
    banksoal_id uuid NOT NULL,
    soal_id uuid NOT NULL,
    peserta_id uuid NOT NULL,
    jadwal_id uuid NOT NULL,
    jawab character varying(255) DEFAULT '0'::character varying NOT NULL,
    jawab_complex character varying(255) DEFAULT '[]'::character varying,
    menjodohkan text,
    mengurutkan text,
    benar_salah text,
    setuju_tidak text,
    esay text,
    ragu_ragu character(1) DEFAULT '0'::bpchar NOT NULL,
    iscorrect character(1) DEFAULT '0'::bpchar NOT NULL,
    answered boolean DEFAULT false NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.jawaban_pesertas OWNER TO postgres;

--
-- Name: jawaban_soals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.jawaban_soals (
    id uuid NOT NULL,
    soal_id uuid NOT NULL,
    text_jawaban text NOT NULL,
    correct character(1) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    label_mark character varying(255)
);


ALTER TABLE public.jawaban_soals OWNER TO postgres;

--
-- Name: jurusans; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.jurusans (
    id uuid NOT NULL,
    kode character varying(255) NOT NULL,
    nama character varying(255) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.jurusans OWNER TO postgres;

--
-- Name: matpels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.matpels (
    id uuid NOT NULL,
    kode_mapel character varying(100) NOT NULL,
    jurusan_id text,
    agama_id text,
    correctors character varying(255),
    nama character varying(255) NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.matpels OWNER TO postgres;

--
-- Name: menuses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.menuses (
    code character varying(255) NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.menuses OWNER TO postgres;

--
-- Name: migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.migrations (
    id integer NOT NULL,
    migration character varying(255) NOT NULL,
    batch integer NOT NULL
);


ALTER TABLE public.migrations OWNER TO postgres;

--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.migrations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.migrations_id_seq OWNER TO postgres;

--
-- Name: migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.migrations_id_seq OWNED BY public.migrations.id;


--
-- Name: penilaian_argument; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.penilaian_argument (
    id uuid NOT NULL,
    banksoal_id uuid NOT NULL,
    peserta_id uuid NOT NULL,
    jawab_id uuid NOT NULL,
    corrected_by uuid NOT NULL,
    point double precision NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.penilaian_argument OWNER TO postgres;

--
-- Name: penilaian_esay; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.penilaian_esay (
    id uuid NOT NULL,
    banksoal_id uuid NOT NULL,
    peserta_id uuid NOT NULL,
    jawab_id uuid NOT NULL,
    corrected_by uuid NOT NULL,
    point double precision NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.penilaian_esay OWNER TO postgres;

--
-- Name: personal_access_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.personal_access_tokens (
    id bigint NOT NULL,
    tokenable_type character varying(255) NOT NULL,
    tokenable_id uuid NOT NULL,
    name character varying(255) NOT NULL,
    token character varying(64) NOT NULL,
    abilities text,
    last_used_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.personal_access_tokens OWNER TO postgres;

--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.personal_access_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.personal_access_tokens_id_seq OWNER TO postgres;

--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.personal_access_tokens_id_seq OWNED BY public.personal_access_tokens.id;


--
-- Name: pesertas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pesertas (
    id uuid NOT NULL,
    sesi integer NOT NULL,
    no_ujian character varying(50) NOT NULL,
    agama_id uuid NOT NULL,
    jurusan_id uuid NOT NULL,
    nama character varying(255) NOT NULL,
    password character varying(255) NOT NULL,
    api_token character varying(255),
    status integer DEFAULT 1 NOT NULL,
    block_reason character varying(255),
    antiblock boolean DEFAULT false NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pesertas OWNER TO postgres;

--
-- Name: role_menuses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.role_menuses (
    role character varying(255) NOT NULL,
    code character varying(255) NOT NULL
);


ALTER TABLE public.role_menuses OWNER TO postgres;

--
-- Name: sesi_schedules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sesi_schedules (
    id uuid NOT NULL,
    jadwal_id uuid NOT NULL,
    sesi integer DEFAULT 1 NOT NULL,
    peserta_ids text NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sesi_schedules OWNER TO postgres;

--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settings (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    value text NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: siswa_ujians; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.siswa_ujians (
    id uuid NOT NULL,
    peserta_id uuid NOT NULL,
    jadwal_id uuid NOT NULL,
    mulai_ujian character varying(255) NOT NULL,
    mulai_ujian_shadow character varying(255) NOT NULL,
    selesai_ujian character varying(255),
    uploaded integer DEFAULT 0 NOT NULL,
    sisa_waktu integer NOT NULL,
    status_ujian character(255) NOT NULL,
    out_ujian_counter integer DEFAULT 0 NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.siswa_ujians OWNER TO postgres;

--
-- Name: soals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.soals (
    id uuid NOT NULL,
    banksoal_id uuid NOT NULL,
    tipe_soal integer NOT NULL,
    case_sensitive integer DEFAULT 1 NOT NULL,
    pertanyaan text NOT NULL,
    rujukan text,
    audio character varying(255),
    direction character varying(255),
    analys text,
    layout integer DEFAULT 1 NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.soals OWNER TO postgres;

--
-- Name: COLUMN soals.tipe_soal; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.soals.tipe_soal IS '1: Pilihan Ganda | 2: Esay | 3: Listening';


--
-- Name: tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tokens (
    id uuid NOT NULL,
    token character varying(255) NOT NULL,
    status character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    CONSTRAINT tokens_status_check CHECK (((status)::text = ANY ((ARRAY['0'::character varying, '1'::character varying])::text[])))
);


ALTER TABLE public.tokens OWNER TO postgres;

--
-- Name: ujians; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ujians (
    id uuid NOT NULL,
    jadwal_id uuid NOT NULL,
    status character varying(255) DEFAULT 'aktif'::character varying NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    CONSTRAINT ujians_status_check CHECK (((status)::text = ANY ((ARRAY['aktif'::character varying, 'selesai'::character varying])::text[])))
);


ALTER TABLE public.ujians OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    email_verified_at timestamp(0) without time zone,
    password character varying(255) NOT NULL,
    role character varying(255) DEFAULT 'guru'::character varying NOT NULL,
    deleted_by uuid,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: exo_backups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exo_backups ALTER COLUMN id SET DEFAULT nextval('public.exo_backups_id_seq'::regclass);


--
-- Name: feature_infos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.feature_infos ALTER COLUMN id SET DEFAULT nextval('public.feature_infos_id_seq'::regclass);


--
-- Name: migrations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations ALTER COLUMN id SET DEFAULT nextval('public.migrations_id_seq'::regclass);


--
-- Name: personal_access_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens ALTER COLUMN id SET DEFAULT nextval('public.personal_access_tokens_id_seq'::regclass);


--
-- Data for Name: agamas; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.agamas (id, kode, nama, created_at, updated_at) VALUES ('3aed771a-9458-4cce-9811-8b0b50bfe462', 'ISLAM', 'Islam', '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.agamas (id, kode, nama, created_at, updated_at) VALUES ('6e4c117b-b057-44a3-98ab-d54d197030de', 'PROTESTAN', 'Protestan', '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.agamas (id, kode, nama, created_at, updated_at) VALUES ('dae66fe2-5785-4b44-892b-6a40c1c2e1f1', 'KATOLIK', 'Katolik', '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.agamas (id, kode, nama, created_at, updated_at) VALUES ('8194f3f2-501b-420f-a496-85fded97beb0', 'HINDU', 'Hindu', '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.agamas (id, kode, nama, created_at, updated_at) VALUES ('b835ff17-369c-4250-a565-000a06953adf', 'BUDHA', 'Budha', '2024-02-02 19:23:21', '2024-02-02 19:23:21');


--
-- Data for Name: banksoal_adaptif; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: banksoals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: directories; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: event_ujians; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: exo_backups; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: failed_jobs; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: feature_infos; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (1, 'form_setting_ujian_event', 'v1', '<p>Biasanya kita mengadakan ujian</p><ul> <li>UH (Ulangan Harian)</li><li>UTS (Ulangan Tengah Semester)</li></ul> <p>inilah kita sebut &#39;event&#39; <br/><br/> Bila kolom ini diisi, ujian akan menginduk kepada event yang kita buat pada menu <u>ujian </u>&gt; <u>event ujian</u><br/><br/> Kelebihan menggunakan event adalah</p><ol> <li>Ubah setting sesi siswa tiap-tiap event sesuai kebutuhan.</li><li>Jadwal dalam kartu ujian siswa</li><li>Absensi</li><li>Berita Acara</li><li>dll</li></ol> <p>Pada ujian yang menginduk kepada event, sesi ujian siswa harus di setting pada menu event. Sesi pada event dapat berbeda dengan sesi default<br/> Kosongkan kolom ini sehingga sesi tetap menggunakan default<br/> <br/> ExtraordinaryCBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (2, 'page_peserta_tabel', 'v1', '<p><strong>Manage peserta ujian.</strong></p><p>Disini kamu bisa melihat data peserta ujian, yang mana mereka adalah orang-orang yang akan melakukan ujian bisa siswa/umum.</p><p>Data yang kamu lihat disini adalah data rahasia karena menyangkut dengan informasi login dan password yang digunakan untuk mengerjakan ujian.</p><p>Untuk penginputan data peserta anda bisa menggunakan 2 opsi:</p><ol><li>Menggunakan form manual</li><li>Menggunakan file excel</li></ol><p>Kami sangat menyarankan untuk menggunakan file excel karena dapat mempermudah anda dalam penginputan.</p><p>Pada halaman ini juga kamu dapat menghapus data peserta ujian namun harus diingat bahwa <strong>ketika anda menghapus peserta</strong> maka semua data yang terkait dengan peserta akan ikut <strong>terhapus</strong> termasuk juga data nilai dan analisa.</p><p>&nbsp;</p><p>Extraordinary CBT&nbsp;</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (3, 'page_grup_tabel', 'v1', '<p><strong>Manage grup</strong></p><p>Pada menu ini berisi grup pada ujian.</p><p>Apa kegunaan grup?</p><p>Grup akan digunakan untuk mengelompokkan peserta ujian. yang mana ini akan berguna pada penjadwalan dan reporting.</p><p>Pada grup terdapat 2 tipe yaitu parent dan children.</p><p>Parent adalah grup yang memiliki parent "none" atau kosong. sedangkan Child adalah grup yang memiliki parent selain "none".</p><p>Contoh penggunakan grup.</p><ul><li><strong>Kelas 7</strong> parent -&gt; ''none''</li><li><strong>Kelas 7A</strong> parent -&gt; ''Kelas 7''</li><li><strong>Kelas 7B</strong> parent -&gt; Kelas 7''</li><li><strong>Kelas 7C</strong> parent -&gt; ''Kelas 7''</li></ul><p>&nbsp;</p><ul><li><strong>Kelas 8</strong> parent -&gt; ''none''</li><li><strong>Kelas 8A</strong> parent -&gt; ''Kelas 8''</li></ul><p>&nbsp;</p><p>Pada grup ini juga anda bisa menambahkan anggota, perlu diingat sebaiknya anda menambahkan anggota <strong>hanya&nbsp;</strong>pada child bila kelas tersebut memiliki child. pada contoh diatas anda sebaiknya menambahkan grup hanya pada 7A, 7B, 7C, 8A tidak pada grup parent.</p><p>Jangan pernah menghapus grup bila grup ini telah atau sedang digunakan untuk ujian karena bisa menyebabkan gagal sistem pada saat scanning grup di jadwal.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (4, 'page_jurusan_tabel', 'v1', '<p><strong>Manage Jurusan</strong></p><p>Pada halaman ini kamu dapat melihat data jurusan dalam bentuk tabel.</p><p>Jurusan berguna untuk pengelompokan peserta ujian pada jadwal dan reporting. Jurusan memiliki scope lebih besar dan lebih luas dari <span style="text-decoration: underline;">grup.</span></p><p>Kode jurusan bisa anda isi dengan unique atau biarkan sistem mengenerate otomatis.</p><p>Kode jurusan akan digunakan untuk import data peserta ujian.</p><p>Perlu diingat dan selalu diingat bahwa pada dasarnya kami sangat tidak menyarankan untuk menghapus data jurusan / mengubah kode jurusan ketika sudah dibuat.&nbsp;</p><p>Sekali kamu menghapus data ujian maka semua data yang terkait dengan jurusan ini akan dihapus termasuk peserta dan saat peserta dihapus maka akan menghapus yang lainnya efek ini akan menjadi domino.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (5, 'page_matpel_tabel', 'v1', '<p><strong>Manage Matpel A.K.A Mata Pelajaran</strong></p><p>Pada halaman ini kamu dapat melihat data mata pelajaran.</p><p>Mata pelajaran adalah suatu grup dalam soal.</p><p>Terdapat 3 matpel yang dapat kamu tentukan sesuai dengan kebutuhan.</p><ul><li>Matpel UMUM</li><li>Matpel Agama</li><li>Matpel Khusus</li></ul><p>Matpel umum digunakan dan akan dipakai oleh seluruh peserta didik tanpa terkecuali.</p><p>Matpel agama digunakan oleh peserta ujian dengan agama yang ditentukan.</p><p>Matpel khusus digunakan oleh peserta ujian dengan jurusan yang ditentukan. matpel khusus bisa ditambahkan lebih dari 1 jurusan.</p><p>Penggunaan matpel khusus bisa dicontohkan sebagai berikut:</p><p>Nama matpel: Matematika Teknik</p><p>Jurusan: Teknik Survei dan Pemetaan, Geomatika, Teknik Gambar Bangunan</p><p>&nbsp;</p><p>Pada matpel juga anda harus mengisi pengoreksi yang akan memberikan penilaian pada tipe-tipe soal yang berhubungan dengan penilaian manual. Pengoreksi dapat berisi lebih dari 1.</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (6, 'page_user_tabel', 'v1', '<p><strong>Manage user</strong></p><p>Pada halaman ini kamu dapat melihat data user.</p><p>User dapat diinput menggunakan cara</p><ul><li>Form manual</li><li>Import data excel</li></ul><p>Kami sangat menyarankan untuk membuat user menggunakan excel untuk kemudahan.</p><p>User dapat memiliki akses untuk melakukan penginputan soal dan bisa ditambahkan sebagai tim pengoreksi soal pada data matpel.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (7, 'page_banksoal_tabel', 'v1', '<p><strong>Manage Banksoal</strong></p><p>Pada halaman ini kamu dapat melihat semua banksoal, kalau kamu adalah user standard maka kamu hanya dapat melihat banksoal yang dibuat oleh kamu sendiri.</p><p>Banksoal adalah cara aplikasi mengelompokkan soal-soal.</p><p>Kamu dapat melakukan edit, hapus, dan juga menghapus banksoal.&nbsp;</p><p>Kami sangat menyarankan untuk mengunci banksoal bila telah selesai melakukan input soal, dengan begitu banksoal anda tidak dapat dilihat, diduplikat apalagi dihapus oleh orang lain termasuk oleh administrator.&nbsp;</p><p>Tetapi kamu harus mengingat password kunci banksoal karena sekali anda lupa, banksoal ini tidak akan terbuka selamanya. tidak ada mekanisme pada aplikasi untuk membuka kunci.</p><p>Banksoal yang dikunci masih bisa digunakan untuk ujian siswa. jadi kamu tidak perlu membuka kunci bila banksoal akan digunakan untuk ujian.</p><p>Kami sangat tidak menyarankan untuk mengedit apalagi menghapus banksoal saat setelah/sedang dipakai untuk ujian pada jadwal. Kamu dapat menggunakan fitur duplikat.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (8, 'page_soal_tabel', 'v1', '<p><strong>Manage soal</strong></p><p>Pada halaman ini kamu dapat melihat data soal yang berada didalam banksoal.</p><p>Soal yang kamu lihat adalah soal yang berurut berdasarkan waktu kamu membuat soal.&nbsp;</p><p>Kamu dapat melihat soal dan opsi pada tabel dengan klik button detail.</p><p>&nbsp;</p><p>Terdapat 3 cara input soal</p><ul><li>Input form manual</li><li>Import file .docx</li><li>Paste text</li></ul><p>Kami sangat menyarankan untuk menggunakan input form untuk hasil yang lebih baik dan komplek, gunakan import file bila dirasa soal itu berisi text sederhana.</p><p>Kami tidak menyarankan anda secara keras untuk mengedit / menekan tombol update meskipun kamu tidak melakukan update. Hal tersebut dapat menyebabkan gagal scanning soal pada analisa dan ujian.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (9, 'page_soal_template_tabel', 'v1', '<p><strong>Paste soal</strong></p><p>Pada halaman ini kamu dapat membuat soal dengan paste soal pada input form yang disediakan.&nbsp;</p><p>Kamu harus menggunakan format yang telah ada. Hanya ada 2 tipe yang dapat diinputkan pada halaman ini yaitu Pilihan Ganda dan Esay.</p><p>Pastikan soal yang kamu "paste" pada input form sesuai dengan Tipe soal yang dipilih.</p><p>&nbsp;</p><p>Extraordinary CBT&nbsp;</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (10, 'page_soal_doc_tabel', 'v1', '<p><strong>Import soal</strong></p><p>Pada halaman ini kamu dapat membuat soal dengan import soal .docx pada form yang disediakan.</p><p>Kami menyediakan 2 opsi template yang kamu bisa pakai</p><ul><li>Format standard - format-1</li><li>Format table - format-2</li></ul><p>&nbsp;</p><p>Pastikan kamu telah memilih tipe soal yang sesuai dengan yang anda akan import.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (11, 'page_status_ujian_table', 'v1', '<p><strong>Status ujian</strong></p><p>Pada halaman ini kamu dapat melihat daftar ujian yang dilaksanakan. jadwal yang ditampilkan pada halaman ini adalah jadwal ujian yang sedang aktif.</p><p>Pada halaman ini juga ditampilkan token yang bisa kamu release bila belum aktif.</p><p>Setiap record jadwal dapat diganti sesia yang aktif dengan merubah dropdown lalu klik simpan.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);
INSERT INTO public.feature_infos (id, name, code, content, created_at, updated_at) VALUES (12, 'page_status_peserta_table', 'v1', '<p><strong>Status peserta</strong></p><p>Pada halaman ini kamu dapat melihat peserta ujian yang masuk kedalam ujian.&nbsp;</p><p>Kamu dapat melakukan reset dan force close pada tiap peserta. Force close hanya berlaku jika peserta belum menyelesaikan ujiannya.</p><p>Reset ujian akan menghapus nilai dan semua jawaban peserta.</p><p>Bila kamu mengaktifkan socket, kamu dimungkinkan untuk melihat status koneksi peserta.</p><p>Waktu pengerjaan peserta dimunginkan untuk ditambah bila dirasa mengalami kendala, penambahan waktu tidak diperbolehkan untuk melebihi waktu saat ini. perkirakan penambahan waktu dengan waktu idle peserta.</p><p>Contoh kasus: Seandainya peserta menunggu 10 menit untuk perbaikan atau pindah komputer, maka beri tambahan waktu 10 menit bila kamu menambah 15 menit sistem akan menolak request tersebut. <br/><br/>Peserta trouble pukul 09:00, trouble fix pukul 09:10, beri waktu tambahan 10 menit.</p><p>&nbsp;</p><p>Extraordinary CBT</p>', NULL, NULL);


--
-- Data for Name: files; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: group_members; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: groups; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: hasil_ujians; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: jadwals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: jawaban_pesertas; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: jawaban_soals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: jurusans; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.jurusans (id, kode, nama, deleted_by, deleted_at) VALUES ('647f3ee4-f9e8-4298-a853-c89cdb7afc8f', '1945', 'UMUM (tanpa-jurusan)', NULL, NULL);


--
-- Data for Name: matpels; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: menuses; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.menuses (code, name) VALUES ('00001A', 'Edit instansi');
INSERT INTO public.menuses (code, name) VALUES ('00002A', 'Master peserta');
INSERT INTO public.menuses (code, name) VALUES ('00003A', 'Master group-peserta');
INSERT INTO public.menuses (code, name) VALUES ('00004A', 'Master jurusan');
INSERT INTO public.menuses (code, name) VALUES ('00005A', 'Master matpel');
INSERT INTO public.menuses (code, name) VALUES ('00006A', 'Master user');
INSERT INTO public.menuses (code, name) VALUES ('00007A', 'Master agama');
INSERT INTO public.menuses (code, name) VALUES ('00008A', 'Banksoal');
INSERT INTO public.menuses (code, name) VALUES ('00009A', 'Event ujian');
INSERT INTO public.menuses (code, name) VALUES ('00010A', 'Jadwal ujian');
INSERT INTO public.menuses (code, name) VALUES ('00011A', 'File media');
INSERT INTO public.menuses (code, name) VALUES ('00012A', 'Status ujian');
INSERT INTO public.menuses (code, name) VALUES ('00013A', 'Status peserta');
INSERT INTO public.menuses (code, name) VALUES ('00014A', 'Status login peserta');
INSERT INTO public.menuses (code, name) VALUES ('00015A', 'Blocked peserta');
INSERT INTO public.menuses (code, name) VALUES ('00016A', 'Koreksi esay');
INSERT INTO public.menuses (code, name) VALUES ('00017A', 'Koreksi argumen');
INSERT INTO public.menuses (code, name) VALUES ('00018A', 'Capaian peserta');
INSERT INTO public.menuses (code, name) VALUES ('00019A', 'Kesulitan soal');
INSERT INTO public.menuses (code, name) VALUES ('00020A', 'Hasil ujian');
INSERT INTO public.menuses (code, name) VALUES ('00021A', 'Ledger peserta');
INSERT INTO public.menuses (code, name) VALUES ('00022A', 'Setting');
INSERT INTO public.menuses (code, name) VALUES ('00023A', 'Backup & restore');


--
-- Data for Name: migrations; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.migrations (id, migration, batch) VALUES (1, '2014_10_12_000000_create_users_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (2, '2019_08_19_000000_create_failed_jobs_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (3, '2019_12_14_000001_create_personal_access_tokens_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (4, '2020_07_10_011018_create_jurusans_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (5, '2020_07_10_011145_create_matpels_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (6, '2020_07_10_011228_create_event_ujians_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (7, '2020_07_10_011304_create_pesertas_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (8, '2020_07_10_011355_create_directories_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (9, '2020_07_10_011431_create_banksoals_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (10, '2020_07_10_011535_create_files_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (11, '2020_07_10_011609_create_jadwals_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (12, '2020_07_10_011707_create_hasil_ujians_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (13, '2020_07_10_011745_create_soals_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (14, '2020_07_10_011826_create_jawaban_soals_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (15, '2020_07_10_011852_create_jawaban_pesertas_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (16, '2020_07_10_011939_create_jawaban_esays_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (17, '2020_07_10_012014_create_agamas_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (18, '2020_07_10_012151_create_settings_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (19, '2020_07_11_112718_create_siswa_ujians_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (20, '2020_07_15_120620_create_ujians_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (21, '2020_07_15_145941_create_tokens_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (22, '2020_10_18_102712_create_sesi_schedules_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (23, '2021_03_09_184343_create_groups_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (24, '2021_03_09_184914_create_group_members_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (25, '2021_05_12_093907_create_feature_infos_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (26, '2021_07_17_094457_create_banksoal_adaptif_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (27, '2021_10_11_102624_create_penilaian_argument_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (28, '2022_07_26_080234_create_exo_backups_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (29, '2023_09_01_210528_add_label_mark_to_jawaban_soals_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (30, '2024_01_28_072638_create_menuses_table', 1);
INSERT INTO public.migrations (id, migration, batch) VALUES (31, '2024_01_28_072747_create_role_menuses_table', 1);


--
-- Data for Name: penilaian_argument; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: penilaian_esay; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: personal_access_tokens; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: pesertas; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: role_menuses; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00001A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00002A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00003A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00004A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00005A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00006A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00007A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00008A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00009A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00010A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00011A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00012A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00013A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00014A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00015A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00016A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00017A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00018A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00019A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00020A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00021A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00022A');
INSERT INTO public.role_menuses (role, code) VALUES ('admin', '00023A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00008A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00009A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00010A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00011A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00012A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00013A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00014A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00016A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00017A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00018A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00019A');
INSERT INTO public.role_menuses (role, code) VALUES ('guru', '00020A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00009A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00010A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00011A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00012A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00013A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00014A');
INSERT INTO public.role_menuses (role, code) VALUES ('operator', '00015A');


--
-- Data for Name: sesi_schedules; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.settings (id, name, type, value, deleted_by, deleted_at, created_at, updated_at) VALUES ('be0b7c98-4d71-4926-88ff-688f7f6ebd96', 'set_sekolah', 'sekolah', '{"logo":"","nama_sekolah":"","email":"","alamat":"","kepala_sekolah":"","nip_kepsek":"","tingkat":"SMK-SMA"}', NULL, NULL, '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.settings (id, name, type, value, deleted_by, deleted_at, created_at, updated_at) VALUES ('eccd4818-082c-4488-b0f7-3fb5f866bb02', 'token', 'general', '900', NULL, NULL, '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.settings (id, name, type, value, deleted_by, deleted_at, created_at, updated_at) VALUES ('a59edeb9-9660-4876-85fc-a5863ed8c1c8', 'ujian', 'general', '{"reset":false}', NULL, NULL, '2024-02-02 19:23:21', '2024-02-02 19:23:21');
INSERT INTO public.settings (id, name, type, value, deleted_by, deleted_at, created_at, updated_at) VALUES ('bbb109d4-9e1d-44ed-b0ea-f9de1f12aa68', 'user-agent-whitelist', 'general', '"*"', NULL, NULL, '2024-02-02 19:23:21', '2024-02-02 19:23:21');


--
-- Data for Name: siswa_ujians; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: soals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tokens; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.tokens (id, token, status, created_at, updated_at) VALUES ('978f68b7-4105-424b-b6b8-49dfc1f2cb35', 'ZYENG', '0', '2024-02-02 19:23:21', '2024-02-02 19:23:21');


--
-- Data for Name: ujians; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.users (id, name, email, email_verified_at, password, role, deleted_by, deleted_at, created_at, updated_at) VALUES ('43d60b70-2851-4d04-87ec-eb9dfcc127b3', 'Administrator', 'admin@shellrean.com', NULL, '$2y$10$u0.Un86.mJLXNv2UbBpyVeYWd3LA.cXGugJdL8R5my8eKlEYmDa3m', 'admin', NULL, NULL, '2024-02-02 19:23:21', '2024-02-02 19:23:21');


--
-- Name: exo_backups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.exo_backups_id_seq', 1, false);


--
-- Name: feature_infos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.feature_infos_id_seq', 12, true);


--
-- Name: migrations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.migrations_id_seq', 31, true);


--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.personal_access_tokens_id_seq', 1, false);


--
-- Name: agamas agamas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.agamas
    ADD CONSTRAINT agamas_pkey PRIMARY KEY (id);


--
-- Name: banksoal_adaptif banksoal_adaptif_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.banksoal_adaptif
    ADD CONSTRAINT banksoal_adaptif_pkey PRIMARY KEY (id);


--
-- Name: banksoals banksoals_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.banksoals
    ADD CONSTRAINT banksoals_pkey PRIMARY KEY (id);


--
-- Name: directories directories_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.directories
    ADD CONSTRAINT directories_pkey PRIMARY KEY (id);


--
-- Name: event_ujians event_ujians_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_ujians
    ADD CONSTRAINT event_ujians_pkey PRIMARY KEY (id);


--
-- Name: exo_backups exo_backups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exo_backups
    ADD CONSTRAINT exo_backups_pkey PRIMARY KEY (id);


--
-- Name: failed_jobs failed_jobs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failed_jobs
    ADD CONSTRAINT failed_jobs_pkey PRIMARY KEY (id);


--
-- Name: feature_infos feature_infos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.feature_infos
    ADD CONSTRAINT feature_infos_pkey PRIMARY KEY (id);


--
-- Name: files files_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.files
    ADD CONSTRAINT files_pkey PRIMARY KEY (id);


--
-- Name: group_members group_members_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.group_members
    ADD CONSTRAINT group_members_pkey PRIMARY KEY (id);


--
-- Name: groups groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (id);


--
-- Name: hasil_ujians hasil_ujians_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.hasil_ujians
    ADD CONSTRAINT hasil_ujians_pkey PRIMARY KEY (id);


--
-- Name: jadwals jadwals_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jadwals
    ADD CONSTRAINT jadwals_pkey PRIMARY KEY (id);


--
-- Name: jawaban_pesertas jawaban_pesertas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_pesertas
    ADD CONSTRAINT jawaban_pesertas_pkey PRIMARY KEY (id);


--
-- Name: jawaban_soals jawaban_soals_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_soals
    ADD CONSTRAINT jawaban_soals_pkey PRIMARY KEY (id);


--
-- Name: jurusans jurusans_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jurusans
    ADD CONSTRAINT jurusans_pkey PRIMARY KEY (id);


--
-- Name: jurusans kode; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jurusans
    ADD CONSTRAINT kode UNIQUE (kode);


--
-- Name: matpels matpels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.matpels
    ADD CONSTRAINT matpels_pkey PRIMARY KEY (id);


--
-- Name: menuses menuses_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.menuses
    ADD CONSTRAINT menuses_pkey PRIMARY KEY (code);


--
-- Name: migrations migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations
    ADD CONSTRAINT migrations_pkey PRIMARY KEY (id);


--
-- Name: penilaian_argument penilaian_argument_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_argument
    ADD CONSTRAINT penilaian_argument_pkey PRIMARY KEY (id);


--
-- Name: penilaian_esay penilaian_esay_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_esay
    ADD CONSTRAINT penilaian_esay_pkey PRIMARY KEY (id);


--
-- Name: personal_access_tokens personal_access_tokens_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens
    ADD CONSTRAINT personal_access_tokens_pkey PRIMARY KEY (id);


--
-- Name: personal_access_tokens personal_access_tokens_token_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens
    ADD CONSTRAINT personal_access_tokens_token_unique UNIQUE (token);


--
-- Name: pesertas pesertas_no_ujian_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pesertas
    ADD CONSTRAINT pesertas_no_ujian_unique UNIQUE (no_ujian);


--
-- Name: pesertas pesertas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pesertas
    ADD CONSTRAINT pesertas_pkey PRIMARY KEY (id);


--
-- Name: role_menuses role_menuses_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role_menuses
    ADD CONSTRAINT role_menuses_pkey PRIMARY KEY (role, code);


--
-- Name: sesi_schedules sesi_schedules_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sesi_schedules
    ADD CONSTRAINT sesi_schedules_pkey PRIMARY KEY (id);


--
-- Name: settings settings_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings
    ADD CONSTRAINT settings_pkey PRIMARY KEY (id);


--
-- Name: siswa_ujians siswa_ujians_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.siswa_ujians
    ADD CONSTRAINT siswa_ujians_pkey PRIMARY KEY (id);


--
-- Name: soals soals_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.soals
    ADD CONSTRAINT soals_pkey PRIMARY KEY (id);


--
-- Name: tokens tokens_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tokens
    ADD CONSTRAINT tokens_pkey PRIMARY KEY (id);


--
-- Name: ujians ujians_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ujians
    ADD CONSTRAINT ujians_pkey PRIMARY KEY (id);


--
-- Name: users users_email_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_email_unique UNIQUE (email);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: agamas_kode_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX agamas_kode_index ON public.agamas USING btree (kode);


--
-- Name: banksoal_adaptif_matpel_id_code_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX banksoal_adaptif_matpel_id_code_index ON public.banksoal_adaptif USING btree (matpel_id, code);


--
-- Name: banksoal_adaptif_matpel_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX banksoal_adaptif_matpel_id_index ON public.banksoal_adaptif USING btree (matpel_id);


--
-- Name: banksoals_kode_banksoal_matpel_id_author_directory_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX banksoals_kode_banksoal_matpel_id_author_directory_id_index ON public.banksoals USING btree (kode_banksoal, matpel_id, author, directory_id);


--
-- Name: directories_slug_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX directories_slug_index ON public.directories USING btree (slug);


--
-- Name: feature_infos_name_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX feature_infos_name_index ON public.feature_infos USING btree (name);


--
-- Name: group_members_group_id_student_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX group_members_group_id_student_id_index ON public.group_members USING btree (group_id, student_id);


--
-- Name: groups_parent_id_name_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX groups_parent_id_name_index ON public.groups USING btree (parent_id, name);


--
-- Name: hasil_ujians_banksoal_id_peserta_id_jadwal_id_ujian_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX hasil_ujians_banksoal_id_peserta_id_jadwal_id_ujian_id_index ON public.hasil_ujians USING btree (banksoal_id, peserta_id, jadwal_id, ujian_id);


--
-- Name: jadwals_tanggal_status_ujian_event_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX jadwals_tanggal_status_ujian_event_id_index ON public.jadwals USING btree (tanggal, status_ujian, event_id);


--
-- Name: jawaban_pesertas_banksoal_id_soal_id_peserta_id_jadwal_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX jawaban_pesertas_banksoal_id_soal_id_peserta_id_jadwal_id_index ON public.jawaban_pesertas USING btree (banksoal_id, soal_id, peserta_id, jadwal_id);


--
-- Name: jawaban_soals_soal_id_correct_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX jawaban_soals_soal_id_correct_index ON public.jawaban_soals USING btree (soal_id, correct);


--
-- Name: jurusans_kode_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX jurusans_kode_index ON public.jurusans USING btree (kode);


--
-- Name: matpels_kode_mapel_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX matpels_kode_mapel_index ON public.matpels USING btree (kode_mapel);


--
-- Name: penilaian_argument_banksoal_id_peserta_id_jawab_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX penilaian_argument_banksoal_id_peserta_id_jawab_id_index ON public.penilaian_argument USING btree (banksoal_id, peserta_id, jawab_id);


--
-- Name: penilaian_esay_indexees0; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX penilaian_esay_indexees0 ON public.penilaian_esay USING btree (banksoal_id, peserta_id, jawab_id, corrected_by);


--
-- Name: personal_access_tokens_tokenable_type_tokenable_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX personal_access_tokens_tokenable_type_tokenable_id_index ON public.personal_access_tokens USING btree (tokenable_type, tokenable_id);


--
-- Name: pesertas_no_ujian_api_token_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX pesertas_no_ujian_api_token_index ON public.pesertas USING btree (no_ujian, api_token);


--
-- Name: sesi_schedules_jadwal_id_sesi_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX sesi_schedules_jadwal_id_sesi_index ON public.sesi_schedules USING btree (jadwal_id, sesi);


--
-- Name: settings_name_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX settings_name_index ON public.settings USING btree (name);


--
-- Name: siswa_ujians_peserta_id_jadwal_id_status_ujian_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX siswa_ujians_peserta_id_jadwal_id_status_ujian_index ON public.siswa_ujians USING btree (peserta_id, jadwal_id, status_ujian);


--
-- Name: soals_banksoal_id_tipe_soal_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX soals_banksoal_id_tipe_soal_index ON public.soals USING btree (banksoal_id, tipe_soal);


--
-- Name: ujians_jadwal_id_status_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ujians_jadwal_id_status_index ON public.ujians USING btree (jadwal_id, status);


--
-- Name: users_email_role_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX users_email_role_index ON public.users USING btree (email, role);


--
-- Name: banksoals banksoals_author_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.banksoals
    ADD CONSTRAINT banksoals_author_foreign FOREIGN KEY (author) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: banksoals banksoals_directory_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.banksoals
    ADD CONSTRAINT banksoals_directory_id_foreign FOREIGN KEY (directory_id) REFERENCES public.directories(id) ON DELETE CASCADE;


--
-- Name: banksoals banksoals_matpel_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.banksoals
    ADD CONSTRAINT banksoals_matpel_id_foreign FOREIGN KEY (matpel_id) REFERENCES public.matpels(id) ON DELETE CASCADE;


--
-- Name: group_members group_members_group_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.group_members
    ADD CONSTRAINT group_members_group_id_foreign FOREIGN KEY (group_id) REFERENCES public.groups(id) ON DELETE CASCADE;


--
-- Name: group_members group_members_student_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.group_members
    ADD CONSTRAINT group_members_student_id_foreign FOREIGN KEY (student_id) REFERENCES public.pesertas(id) ON DELETE CASCADE;


--
-- Name: hasil_ujians hasil_ujians_banksoal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.hasil_ujians
    ADD CONSTRAINT hasil_ujians_banksoal_id_foreign FOREIGN KEY (banksoal_id) REFERENCES public.banksoals(id) ON DELETE CASCADE;


--
-- Name: hasil_ujians hasil_ujians_jadwal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.hasil_ujians
    ADD CONSTRAINT hasil_ujians_jadwal_id_foreign FOREIGN KEY (jadwal_id) REFERENCES public.jadwals(id) ON DELETE CASCADE;


--
-- Name: hasil_ujians hasil_ujians_peserta_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.hasil_ujians
    ADD CONSTRAINT hasil_ujians_peserta_id_foreign FOREIGN KEY (peserta_id) REFERENCES public.pesertas(id) ON DELETE CASCADE;


--
-- Name: jawaban_pesertas jawaban_pesertas_banksoal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_pesertas
    ADD CONSTRAINT jawaban_pesertas_banksoal_id_foreign FOREIGN KEY (banksoal_id) REFERENCES public.banksoals(id) ON DELETE CASCADE;


--
-- Name: jawaban_pesertas jawaban_pesertas_jadwal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_pesertas
    ADD CONSTRAINT jawaban_pesertas_jadwal_id_foreign FOREIGN KEY (jadwal_id) REFERENCES public.jadwals(id) ON DELETE CASCADE;


--
-- Name: jawaban_pesertas jawaban_pesertas_peserta_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_pesertas
    ADD CONSTRAINT jawaban_pesertas_peserta_id_foreign FOREIGN KEY (peserta_id) REFERENCES public.pesertas(id) ON DELETE CASCADE;


--
-- Name: jawaban_pesertas jawaban_pesertas_soal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_pesertas
    ADD CONSTRAINT jawaban_pesertas_soal_id_foreign FOREIGN KEY (soal_id) REFERENCES public.soals(id) ON DELETE CASCADE;


--
-- Name: jawaban_soals jawaban_soals_soal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jawaban_soals
    ADD CONSTRAINT jawaban_soals_soal_id_foreign FOREIGN KEY (soal_id) REFERENCES public.soals(id) ON DELETE CASCADE;


--
-- Name: penilaian_argument penilaian_argument_banksoal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_argument
    ADD CONSTRAINT penilaian_argument_banksoal_id_foreign FOREIGN KEY (banksoal_id) REFERENCES public.banksoals(id) ON DELETE CASCADE;


--
-- Name: penilaian_argument penilaian_argument_corrected_by_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_argument
    ADD CONSTRAINT penilaian_argument_corrected_by_foreign FOREIGN KEY (corrected_by) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: penilaian_argument penilaian_argument_jawab_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_argument
    ADD CONSTRAINT penilaian_argument_jawab_id_foreign FOREIGN KEY (jawab_id) REFERENCES public.jawaban_pesertas(id) ON DELETE CASCADE;


--
-- Name: penilaian_argument penilaian_argument_peserta_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_argument
    ADD CONSTRAINT penilaian_argument_peserta_id_foreign FOREIGN KEY (peserta_id) REFERENCES public.pesertas(id) ON DELETE CASCADE;


--
-- Name: penilaian_esay penilaian_esay_banksoal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_esay
    ADD CONSTRAINT penilaian_esay_banksoal_id_foreign FOREIGN KEY (banksoal_id) REFERENCES public.banksoals(id) ON DELETE CASCADE;


--
-- Name: penilaian_esay penilaian_esay_corrected_by_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_esay
    ADD CONSTRAINT penilaian_esay_corrected_by_foreign FOREIGN KEY (corrected_by) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: penilaian_esay penilaian_esay_jawab_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_esay
    ADD CONSTRAINT penilaian_esay_jawab_id_foreign FOREIGN KEY (jawab_id) REFERENCES public.jawaban_pesertas(id) ON DELETE CASCADE;


--
-- Name: penilaian_esay penilaian_esay_peserta_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penilaian_esay
    ADD CONSTRAINT penilaian_esay_peserta_id_foreign FOREIGN KEY (peserta_id) REFERENCES public.pesertas(id) ON DELETE CASCADE;


--
-- Name: siswa_ujians siswa_ujians_jadwal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.siswa_ujians
    ADD CONSTRAINT siswa_ujians_jadwal_id_foreign FOREIGN KEY (jadwal_id) REFERENCES public.jadwals(id) ON DELETE CASCADE;


--
-- Name: siswa_ujians siswa_ujians_peserta_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.siswa_ujians
    ADD CONSTRAINT siswa_ujians_peserta_id_foreign FOREIGN KEY (peserta_id) REFERENCES public.pesertas(id) ON DELETE CASCADE;


--
-- Name: soals soals_banksoal_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.soals
    ADD CONSTRAINT soals_banksoal_id_foreign FOREIGN KEY (banksoal_id) REFERENCES public.banksoals(id) ON DELETE CASCADE;


--
-- PostgreSQL database dump complete
--

